﻿using System;

namespace Injector.Tools.spike
{
    public static class WindowsAppTarget
    {
        #region head
        #region POINT
        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct POINT
        {
            public int X;
            public int Y;


            public POINT(int x, int y)
            {
                this.X = x;
                this.Y = y;
            }

            public static implicit operator System.Drawing.Point(POINT p)
            {
                return new System.Drawing.Point(p.X, p.Y);
            }

            public static implicit operator POINT(System.Drawing.Point p)
            {
                return new POINT(p.X, p.Y);
            }

        }

        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;
        }

        const int DSTINVERT = 0x00550009;

        #endregion ---POINT---

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        public static extern IntPtr WindowFromPoint(POINT Point);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern IntPtr GetWindowDC(IntPtr hWnd);
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern int GetWindowText(int hWnd, System.Text.StringBuilder text, int count);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern int GetClassName(IntPtr hWnd, System.Text.StringBuilder lpClassName, int nMaxCount);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern uint GetWindowThreadProcessId(IntPtr hWnd, out int lpdwProcessId);

        public static int GetWindowThreadProcessId(IntPtr hWnd)
        {
            int procId;

            if (GetWindowThreadProcessId(hWnd, out procId) > 0)
            {
                // error logic
            }
            return procId;
        }

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern bool GetWindowRect(IntPtr hWnd, out RECT lpRect);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern bool OffsetRect(ref RECT lprc, int dx, int dy);

        [System.Runtime.InteropServices.DllImport("gdi32.dll")]
        static extern bool PatBlt(IntPtr hdc, int nXLeft, int nYLeft, int nWidth, int nHeight, uint dwRop);
        #endregion ---head---

        static string GetWindowText(IntPtr hWnd)
        {
            System.Text.StringBuilder text = new System.Text.StringBuilder(256);
            if (GetWindowText(hWnd.ToInt32(), text, text.Capacity) > 0)
            {
                return text.ToString();
            }

            return String.Empty;
        }

        static string GetClassName(IntPtr hWnd)
        {
            System.Text.StringBuilder className = new System.Text.StringBuilder(100);
            if (GetClassName(hWnd, className, className.Capacity) > 0)
            {
                return className.ToString();
            }

            return String.Empty;
        }

        public static System.Diagnostics.Process GetApplication(IntPtr hWnd)
        {
            int procId = GetWindowThreadProcessId(hWnd);
            System.Diagnostics.Process proc = System.Diagnostics.Process.GetProcessById(procId);
            return proc;
        }

        public static bool IsManaged(System.Diagnostics.Process proc)
        {

            try
            {
                if (proc.Modules == null)
                    return false;

                foreach (System.Diagnostics.ProcessModule procModule in proc.Modules)
                {
                    if (procModule.ModuleName == "mscorlib.dll" || procModule.ModuleName == "mscorlib.ni.dll")
                    {
                        return true;
                    }
                }
            }
            catch
            {
            }

            return false;
        }
        public static string getProcessName(IntPtr hWnd)
        {
            int procId = GetWindowThreadProcessId(hWnd);
            System.Diagnostics.Process proc = System.Diagnostics.Process.GetProcessById(procId);
            return proc.ProcessName;
        }
        public static string getProcessPID(IntPtr hWnd)
        {
            int procId = GetWindowThreadProcessId(hWnd);
            return procId.ToString();
        }
        public static string getModules(IntPtr hWnd)
        {
            int procId = GetWindowThreadProcessId(hWnd);
            System.Diagnostics.Process proc = System.Diagnostics.Process.GetProcessById(procId);
            return getModules(proc);
        }
        public static string getModules(System.Diagnostics.Process proc)
        {
            System.String s = "ERROR: Access denied to the managed dll(s) #b80h89fhg9gb8 " + System.Environment.NewLine + System.Environment.NewLine;

            s += "---------------Items Found--------------" + System.Environment.NewLine;
            try
            {
                // fail to find runtime
                bool couldBe32Bit = false;
                foreach (System.Diagnostics.ProcessModule procModule in proc.Modules)
                {
                    s += procModule.ModuleName;
                    if (procModule.ModuleName.ToLower().Contains("wow64"))
                    {
                        s += " - *" + System.Environment.NewLine;
                        couldBe32Bit = true;
                    }
                    else
                        s += System.Environment.NewLine;
                }
                if (couldBe32Bit)
                    s += System.Environment.NewLine + "*-this could be a 32 bit app";

            }
            catch
            {
                s += "ERROR: Could not access modules-*" + System.Environment.NewLine;
                s += System.Environment.NewLine + "*-this could be a 64 bit app";
            }
            return s;
        }
    }
}